<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceCategory extends Model 
{

    protected $table = 'service_categories';
    public $timestamps = true;
    protected $fillable = array('name');

    public function services()
    {
        return $this->hasMany('App\Models\Service', 'category_id');
    }

    public function uploads()
    {
        return $this->hasMany('App\Models\ServiceCategoryUpload', 'service_category_id');
    }

}